\version "2.16.0"

\paper {
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 2))
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  ragged-last-bottom=##f
  system-count = #12
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Acestea zice Domnul"
  %subtitle = "Die Schöpfung"
  %subsubtitle = "Und Seiner Hände Werk"
  composer = "Sabin Drăgoi (1894 - 1968)" 
  arranger = "I. D. Chirescu / N. Moldoveanu"
  meter = "Largo"
  tagline=""
}

global = {
  \key g \major
  \autoBeamOff
  %\cadenzaOn
  \time 4/4
  \set Staff.midiInstrument = "clarinet"
}

soloWords = \lyricmode {
  A -- ces -- tea zi -- ce Dom -- nul că -- tre i -- u -- dei: 
  Po -- po -- rul meu, ce am fă -- cut ţi -- e  
  şi cu ce v-am su -- pă -- rat pe voi? 
  Pe or -- bii voş -- tri i-am lu -- mi -- nat,   
  pe cei le -- proşi i-am cu -- ră -- ţit, 
  pe băr -- ba -- tul cel ce e -- ra în pat l-am în -- drep -- tat.
  Po -- po -- rul meu, ce am fă -- cut ţi -- e 
  şi cu ce mi-aţi răs -- plă -- tit mi -- e? 
  În loc de ma -- nă, cu fie -- re; 
  în loc de a -- pă, cu o -- ţet 
  şi în loc a mă iu -- bi, pe cru -- ce m-ati pi -- ro -- nit! 
  Che -- ma -- voi nea -- mu -- ri -- le me -- le 
  şi a -- ce -- lea mă vor prea -- mă -- ri 
  îm -- pre -- u -- nă cu Ta -- tăl şi cu Du -- hul Sfânt. 
  A -- min.
}

womenWords = \lyricmode {
  A -- ces -- tea zi -- ce Dom -- nul,
  A -- ces -- tea zi -- ce Dom -- nul că -- tre i -- u -- dei: 
  Po -- po -- rul meu, ce am fă -- cut ţi -- e  
  şi cu ce v-am su -- pă -- rat pe voi? 
  A -- ces -- tea zi -- ce Dom -- nul, a -- ces -- tea zi -- ce Dom -- nul,
  pe băr -- ba -- tul cel ce e -- ra în pat l-am în -- drep -- tat.
  A __
  şi cu ce mi-aţi răs -- plă -- tit mi -- e? 
  A __
  şi în loc a mă iu -- bi, pe cru -- ce m-ati pi -- ro -- nit! 
  Che -- ma -- voi nea -- mu -- ri -- le me -- le 
  şi a -- ce -- lea mă vor prea -- mă -- ri 
  A __ 
  A -- min. A -- min.
}

menWords = \lyricmode {
  A -- ces -- tea zi -- ce Dom -- nul că -- tre i -- u -- dei: 
  Po -- po -- rul meu, ce am fă -- cut ţi -- e  
  şi cu ce v-am su -- pă -- rat pe voi? 
  pe băr -- ba -- tul cel ce e -- ra în pat l-am în -- drep -- tat.
  şi cu ce mi-aţi răs -- plă -- tit mi -- e? 
  şi în loc a mă iu -- bi, pe cru -- ce m-ati pi -- ro -- nit! 
  Che -- ma -- voi nea -- mu -- ri -- le me -- le 
  şi a -- ce -- lea mă vor prea -- mă -- ri 
  A -- min. A -- min.
}
  
soloMusic  = \relative c'' {
  \partial 8 r8
  r1 r r2 r4 r8
  g8^\p
  b4 d d8([ c]) b([ a]) b4.( c8 d4 e) d2 d8([ c]) b([ a]) b4.( c8 d4) e d2. \breathe 
  d4 e2( d4) e d2 d4 d8 d e2 d4( e) d2. d8 d g4( e) d8([ e d c])
  b4 d c( b c) a g2 r1 r4 r8 
  g8 g g g g g4 a8 a b2 r1 r2 r8 
  g g g g g a a b4 c8 d e4 c e e8 g 
  fis4^\f e d8[( e d c] b4) d c( b c) a g r8 d'
  c([ d e fis] g4) fis8([ e]) d2 d4 d8 d c8^\p([d e fis]) g4( fis8[ e]) d2. d8 d
  g4^\f( e) d8([ e d c]) b4 d c( b) c( a) g r8 g^\p b4 d d8([ c]) b a
  b4.( c8 d4 e) d2. r8 g,^\pp b4 d d8([ c]) b([ a]) b4.( c8 d4) e d2. 
  c8^\mark"cresc" d e4 c e g fis e d8([ e d c]) b4 d c( b c) a g r8 d'^\f
  g4( fis8[ g] a4 g fis e) d2 e4 c e e8([ fis]) g2( fis4 e)
  d2. d8 d g4( e) d8([ e d c]) b4 d c( b c) a g \breathe c8^\p d
  e4( g) fis e d2 b4 r d d e( d c) d b2(\fermata b4) r4 r2 g'1^\p 
  \override Hairpin #'minimum-length = #5
  << g1\fermata { s4 s^\< s^\> s\! } >>
  \bar"|."    
}

sopMusic = \relative c'' {
  \partial 8 g8^\p
  b4 d d8([ c]) b([ a]) b4.( c8 d4 e) d2. b8\rest 
  d8^\p d4 d d d d2.( e4) d2 d4 d8([ c]) b4.( c8 d4) e d2 b4\rest
  d4 g2. g4 fis2 d4 d8 d g2 g fis b,4\rest
  d8 d g2 g4( d) d d c( d e) d8([ c]) b4 b8\rest
  g8 b4 d d8([ c]) b([ a]) b4.( c8 d4 e) d2. b8\rest
  g8^\pp b4 d d8([ c]) b([ a]) b4.( c8 d4 e) d2. 
  g8^\mf g g4 g g g8 g g4 g g2 d c4( d e) d8([ c]) b2
  g'1( g g g2.) d8 d g2 g4( d) d d c( d) e( d8[ c]) b2 \breathe
  g'1^\p( g g g g g2.)  
  g8^\mark"cresc" g g4 g g g g g g( d) d d c4( d e) d8([ c]) b4 b8\rest
  d8^\f d1( c2) b c4 c e a g( e dis e) b2. 
  d8 d g2 g4( d) d d c4( d e) d8([ c]) b4 b4\rest
  g'1( g2.) b,4\rest b1\rest b1\rest
  g'1 g2 b,2\rest b4\rest g'4^\pp g2  
  \bar"|."  
}

altMusic = \relative c'' {
  g8 g4 b b8([ a]) g([ fis]) g4.( a8 b4 c) b2. b8\rest
  b8 b4 b b8([ a]) g([ a]) b4.( a8 b4 c) b2 b8([ a]) g([ a]) g4.( a8 b4) c a2 b4\rest
  b4 c2( d4) e d2 b4 b8 b c2 d4( e) d2 b4\rest
  b8 b c4( cis) d8([ e d c]) b4 a g8([ a] b4 c) a g b8\rest
  g8 g4 b b8([ a]) g([ fis]) g4.( a8 b4 c) b2. b8\rest
  g8 g4 b b8([ a]) g([ fis]) g4.( a8 b4 c) b2. 
  e8 e e4 e e e8 e c4 cis d8[( e d c]) b4( a) g8([ a] b4 c) a g2
  g1( g g g2.) b8 b c4( cis) d8([ e d c]) b4 a g8([ a] b4) c( a) g2
  g1( g g g g g2.) e'8 e e4 e e e c cis d8[( e d c]) b4 a g8([ a] b4 c) a g b8\rest
  b8^\f b1( g2) g g4 g c e e( c b a) g2.
  b8 b c4 cis d8[( e d c]) b4( a) g8([ a] b4 c) a g b4\rest
  g1( g2.) b4\rest b1\rest b1\rest
  g'4( f e d8[ c]) b2 b2\rest b4\rest d4 d2
}

tenorMusic = \relative c {
  d8\rest d1\rest d1\rest d2\rest d4\rest d8\rest
  g8 g4 g g g g1 g2 g4 g g2. g4 fis2 d4\rest
  g4 g4.( a8 b4) c4 a2 fis4 g8 g g4.( a8) b4( c) a2 d,4\rest
  g8 g a4( ais) b8([ c b a]) g4 fis e8([ fis] g4 g) fis g2 d1\rest d1\rest
  d1\rest d1\rest d1\rest d2\rest d4\rest 
  c'8^\mf c c4 c b b8 b a4 ais b8([ c b a]) g4( fis) e8([ fis] g4 g) fis g2
  d1\rest d1\rest d1\rest d2\rest d4\rest
  g8 g a4 ais b8([ c b a]) g4 fis e8([ fis] g4) g( fis) g2
  d1\rest d1\rest d1\rest d1\rest d1\rest d2\rest d4\rest 
  c'8 c c4 c b b a ais b8([ c b a]) g4 fis e8([ fis] g4 g) fis g4 d8\rest
  g8^\f g1( e2) d e4 e a a b2.( g4) g2.
  g8 g a4( ais) b8([ c b a]) g4 fis e8([ fis] g4 g) fis g4 d4\rest
  d1\rest d1\rest d1\rest d1\rest
  b'4( d c b8[ a]) b2 d,2\rest d4\rest
  b'4^\pp b2
}

bassMusic = \relative c {
  d8\rest d1\rest d1\rest d2\rest d4\rest d8\rest
  g8 g4 g g g g,1 g2 g4 g g2. c4 d2 d4\rest
  g4 c,2( <g g'>4) c4 d2 d4 g8 g c,2 <g g'>4( c) d2 d4\rest
  g8 g e4( fis8[ g]) g2 g4 fis e( d c) d g,2 d'1\rest d1\rest
  d1\rest d1\rest d1\rest d2\rest d4\rest 
  c'8 c a4 a e e8 e e4 e8([ fis]) g2 g4( fis) e( d c) d g,2
  d'1\rest d1\rest d1\rest d2\rest d4\rest
  g8 g e4( fis8[ g]) g2 g4 fis e( d) c( d) g,2 
  d'1\rest d1\rest d1\rest d1\rest d1\rest d2\rest d4\rest 
  c'8 c a4 a e e e fis8([ g]) g2 g4 fis e( d c) d g, d'8\rest
  g,8 g2.( a8[ b] c2) g4( a8[ b]) c4. b8 a8([ b]) c([ d]) e4( g,8[ a] b4 c) g2.
  g'8 g e4( fis8[ g]) g2 g4 fis e( d c) d g,4 d'4\rest
  d1\rest d1\rest d1\rest d1\rest
  g1 g2 d2\rest d4\rest g4 <g g,>2
}

myScore = \new Score <<
  \new Staff <<
      \set Staff.instrumentName = "Solo Tenor"    
      \new Voice { \global \soloMusic }
      \addlyrics { \soloWords }
      
    >>
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \new Voice { \voiceTwo \global \altMusic }
      \addlyrics { \womenWords }
      
    >>
    \new Staff <<
      \clef bass
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      \addlyrics { \menWords }
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 60
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \soloMusic }
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  %\unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
